#include "c4d_basekey.h"
#include "c4d_basesequence.h"
#include "c4d_basetrack.h"
#include "c4d_baseobject.h"

BaseTrack *BaseKey::GetTrack(void)
{
	BaseSequence *bs=GetSequence();
	if (bs) return bs->GetTrack(); else return NULL;
}

BaseList2D *BaseKey::GetObject(void)
{
	BaseTrack *bs=GetTrack();
	if (bs) return bs->GetObject(); else return NULL;
}

void BaseKey::SetTime(const BaseTime &time)
{
	C4DOS.Bk->SetTime(this,time);
}

BaseTime BaseKey::GetTime(void)
{
	return C4DOS.Bk->GetTime(this);
}

VariableTag *PLAKey::GetPointTag(void)
{
	return C4DOS.Bk->GetPointTag(this);
}

VariableTag *PLAKey::GetHermiteTag(void)
{
	return C4DOS.Bk->GetHermiteTag(this);
}

AnimValue *GetKeyValue(BaseKey *key) { return C4DOS.Bk->GetKeyValue(key); }

BaseKey *BaseKey::Alloc(LONG type)
{
	return C4DOS.Bk->Alloc(type,0);
}

void BaseKey::Free(BaseKey *&bl)
{
	C4DOS.Bl->Free(bl);
	bl=NULL;
}

PluginKey *PluginKey::Alloc(LONG type)
{
	return (PluginKey*)C4DOS.Bk->Alloc(type,0);
}

void PluginKey::Free(PluginKey *&bl)
{
	C4DOS.Bl->Free(bl);
	bl=NULL;
}

PLAKey *PLAKey::Alloc()
{
	return (PLAKey*)C4DOS.Bk->Alloc(Spla,0);
}

void PLAKey::Free(PLAKey *&bl)
{
	C4DOS.Bl->Free(bl);
	bl=NULL;
}
